#!/bin/sh
#
## Copyright (C) Seiko Epson Corporation 2015.
##  This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

sbindir=/usr/local/sbin
pkgrcddir=/usr/lib/epson-backend/rc.d

PATH=$PATH:/usr/local/sbin:/usr/sbin:/sbin:$sbindir
FIX_BUG_VERSION=244

SYSCONFDIR=/etc
SCRIPTDIR=$pkgrcddir
INSTALL="install -m 755"
LN="ln -fs"
RM="rm -f"
SNO=11
KNO=89


#
# Check init scripts directory
#

if [ -d $SYSCONFDIR/init.d ]; then
    funcdir=$SYSCONFDIR/init.d
    if [ -d $funcdir/rc1.d ]; then
	# for suse
	rcdir=$funcdir
    else
	rcdir=$SYSCONFDIR
    fi
elif [ -d $SYSCONFDIR/rc.d ]; then
    rcdir=$SYSCONFDIR/rc.d
    if [ -d $rcdir/init.d ]; then
	funcdir=$rcdir/init.d
    else
	funcdir=$rcdir
    fi
else
    echo Error : Unknow linux distribution
    exit 1
fi


case "$1" in
    #
    # Install script
    #
    install)
    	if type systemctl > /dev/null 2>&1 ; then    		
		systemd_version=`systemctl --version | sed -n -e "s/^systemd\s\([0-9]\+\).*/\1/p"`
		echo "systemd version = $systemd_version"
		echo "Set the service file according to the systemd version."
		if [ -z $systemd_version ] ; then
   			echo "Error.Could not obtain systemd version." 
   			exit 1
		else
   			if [ $systemd_version -ge $FIX_BUG_VERSION ] ; then
   				sed -i -e "s/^Type=.*/Type=oneshot/" /usr/lib/epson-backend/ecbd.service
   				sed -i -e "s/^Restart=.*/Restart=on-failure/" /usr/lib/epson-backend/ecbd.service
			else
				sed -i -e "s/^Type=.*/Type=simple/" /usr/lib/epson-backend/ecbd.service
				sed -i -e "s/^Restart=.*/Restart=no/" /usr/lib/epson-backend/ecbd.service
   			fi
		fi
		
    		if [ -d /usr/lib/systemd/system ] ; then
    			echo "Install Red Hat compatible service file."
   			install -m 644 /usr/lib/epson-backend/ecbd.service /usr/lib/systemd/system/ecbd.service
		else
			echo "Install Debian compatible service file."
   			install -m 644 /usr/lib/epson-backend/ecbd.service /lib/systemd/system/ecbd.service
		fi
		systemctl daemon-reload
	    	systemctl enable ecbd.service
	    	systemctl start ecbd.service
	elif [ -x /usr/lib/lsb/install_initd ] ; then
      	# LSB standard
            echo "Install LSB standard."
		$INSTALL $SCRIPTDIR/ecbd $funcdir/ecbd
		/usr/lib/lsb/install_initd $funcdir/ecbd > /dev/null 2>&1
	elif type update-rc.d > /dev/null 2>&1 ; then
		# Debian compatible
		echo "Install Debian compatible init."
		$INSTALL $SCRIPTDIR/ecbd $funcdir/ecbd
		update-rc.d ecbd defaults $SNO $KNO > /dev/null 2>&1
	elif type chkconfig > /dev/null 2>&1 ; then
            # RedHat compatible
            echo "Install RedHat compatible init."
            $INSTALL $SCRIPTDIR/ecbd $funcdir/ecbd
            chkconfig --add ecbd > /dev/null 2>&1
	else
	    # legacy system
	    for loop in 2 3 4 5 S M ; do
		if [ -d $rcdir/rc$loop.d ]; then
		    $LN $funcdir/ecbd $rcdir/rc$loop.d/S${SNO}ecbd

		elif [ -d $rcdir/rc.$loop ]; then
		    $LN $funcdir/ecbd $rcdir/rc.$loop/S${SNO}ecbd

		fi
	    done
	    for loop in 0 1 6 K ; do
		if [ -d $rcdir/rc$loop.d ]; then
		    $LN $funcdir/ecbd $rcdir/rc$loop.d/K${KNO}ecbd

		elif [ -d $rcdir/rc.$loop ]; then
		    $LN $funcdir/ecbd $rcdir/rc.$loop/K${KNO}ecbd

		fi
	    done
	fi
	;;

    deinstall)
    	if type systemctl > /dev/null 2>&1 ; then	
		systemctl stop ecbd.service
		systemctl disable ecbd.service
		if [ -d /usr/lib/systemd/system ] ; then
    			echo "Deinstall Red Hat compatible systemd."
   			$RM /usr/lib/systemd/system/ecbd.service
		else
			echo "Deinstall Debian compatible systemd."
   			$RM /lib/systemd/system/ecbd.service
		fi
		systemctl daemon-reload
	elif [ ! -x /usr/lib/lsb/remove_initd ] ; then
		# LSB standard
		echo "Deinstall LSB standard."
		/usr/lib/lsb/remove_initd $funcdir/ecbd > /dev/null 2>&1
	elif type update-rc.d > /dev/null 2>&1 ; then
		# Debian compatible
		echo "Deinstall Debian compatible init."
		update-rc.d -f ecbd remove > /dev/null 2>&1
	elif type chkconfig > /dev/null 2>&1 ; then
		# RedHat compatible
		echo "Deinstall RedHat compatible init."
		chkconfig --del ecbd > /dev/null 2>&1
	else
	    # legacy system
	    for loop in 2 3 4 5 S M ; do
		if [ -s $rcdir/rc$loop.d/S${SNO}ecbd ]; then
		    $RM $rcdir/rc$loop.d/S${SNO}ecbd

		elif [ -s $rcdir/rc.$loop/S${SNO}ecbd ]; then
		    $RM $rcdir/rc.$loop/S${SNO}ecbd

		fi
	    done
	    for loop in 0 1 6 K ; do
		if [ -s $rcdir/rc$loop.d/K${KNO}ecbd ]; then
		    $RM $rcdir/rc$loop.d/K${KNO}ecbd

		elif [ -s $rcdir/rc.$loop/K${KNO}ecbd ]; then
		    $RM $rcdir/rc.$loop/K${KNO}ecbd

		fi
	    done
	fi

	if [ -s $funcdir/ecbd ]; then
	    $RM $funcdir/ecbd
	fi

	;;

    *)
	echo "Usage: install-rc_d.sh { install | deinstall }" >&2
	exit 1
	;;
esac

exit 0;
